{========================================================================}
{=                (c) 1995-99 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 01.09.98 - 11:03:01 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMObj, MMDIBCv, MMLevel, MMConect, MMWave, MMDSPObj, MMWavOut,
  MMsystem, MMUtils, MMregs, MMHook, MMDesign, MMACMCvt, MMCstDlg;

type
  TForm1 = class(TForm)
    ACMConverter: TMMACMConverter;
    MMDesigner1: TMMDesigner;
    btnStop: TButton;
    btnPlay: TButton;
    WaveOut: TMMWaveOut;
    WaveFile: TMMWaveFile;
    Connector: TMMConnector;
    MMLevel1: TMMLevel;
    DSPInterface: TMMDSPInterface;
    WaveOpenDialog: TMMWaveOpenDialog;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure DSPInterfaceBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
    procedure DSPInterfaceOpen(Sender: TObject);
    procedure DSPInterfaceClose(Sender: TObject);
    procedure btnPlayClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure WaveOutStop(Sender: TObject);
  private
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

// This demos shows how to play a wavefile and convert it to GSM for live streaming

{==============================================================================}
function acmBuildGSM610Header(SampleRate: integer): PGSM610WaveFormat;
begin
   Result := GlobalAllocMem(sizeOf(TGSM610WaveFormat));
   with Result^ do
   begin
      wfx.wFormatTag     := WAVE_FORMAT_GSM610;
      wfx.nChannels      := 1;
      wfx.nSamplesPerSec := SampleRate;
      wfx.wBitsPerSample := 0;
      wfx.nAvgBytesPerSec:= 0;
      wfx.nBlockAlign    := 65;
      wfx.cbSize         := 2;
      wSamplesPerBlock   := 320;

      case SampleRate of
         8000 : wfx.nAvgBytesPerSec := 1625;
         11025: wfx.nAvgBytesPerSec := 2239;
         22050: wfx.nAvgBytesPerSec := 4478;
         44100: wfx.nAvgBytesPerSec := 8957;
      end;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   WaveOut.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveOutStop(Sender: TObject);
begin
   WaveOut.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnPlayClick(Sender: TObject);
var
   pwfx: PGSM610WaveFormat;
begin
   if WaveOpenDialog.Execute then
   begin
      WaveFile.Wave.FileName := WaveOpenDialog.FileName;

      // build the GSM format
      pwfx := acmBuildGSM610Header(WaveFile.Wave.SampleRate);
      try
         // set the destination format
         ACMConverter.PWaveFormat := PWaveFormatEx(pwfx);
      finally
         GlobalFreePtr(pwfx);
      end;

      // and start the playback/conversion
      WaveOut.Start;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStopClick(Sender: TObject);
begin
   WaveOut.Stop;
end;

{------------------------------------------------------------------------------}
procedure TForm1.DSPInterfaceOpen(Sender: TObject);
begin
// here you can allocate memory, open the connection and so on...
end;

{------------------------------------------------------------------------------}
procedure TForm1.DSPInterfaceClose(Sender: TObject);
begin
// free memory and close the connection here...
end;

{------------------------------------------------------------------------------}
procedure TForm1.DSPInterfaceBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
begin
   // here can you copy the converted data and put it in your own structures or
   // send it out

   // lpWaveHdr^.lpData           - the buffer with data
   // lpWaveHdr^.dwBytesRecorded  - the number of bytes in the buffer

   // You must copy the data because after the event returns the buffer will be re-used !
end;

end.
